classdef class_REVS_driver 
	%REVS_driver
	%   REVS driver class definition
	
	properties
		Kp                                  = 1.0;  % driver PID proportional gain
        Ki                                  = 1.0;  % driver PID integral gain
        Kd                                  = 0.0;  % driver PID derivative gain

        proportional_fade_in_secs           = 1.0;
        proportional_fade_in_min_speed_mps  = 2.0;
		
        lookahead_secs                      = 0.25;
		launch_anticipate_secs              = 0.50;
		
		distance_compensate_enable          = false;    % Distance compensation enable  
        
		brake_gain_norm                     = 0.13;     % 0.13 = REVS1 compatible brake gains
        
        accel_pedal_response_norm           = [0.125, 0.2, 0.5, 4.0];
        accel_pedal_response_speed_mps      = [0.0, 5.0, 10 , 75 ];
    end
	 
end
 